﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 设置应用程序窗体的标题。
        CheckLockKeys()
        dateLabel.Text = Today.ToShortDateString
    End Sub

    Private Sub ShowPanelsCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ShowPanelsCheckBox.CheckedChanged
        ' 如果选择显示面板的能力，则希望使该能力可以选择在状态栏上显示哪个面板。
        GroupBox1.Enabled = ShowPanelsCheckBox.Checked

        ' 根据窗体上的复选框更改状态栏 showpanels 属性。
        Me.status.Visible = ShowPanelsCheckBox.Checked
        Me.numLock.Visible = ShowPanelsCheckBox.Checked
        Me.capsLock.Visible = ShowPanelsCheckBox.Checked
        Me.dateLabel.Visible = ShowPanelsCheckBox.Checked
        Me.progressBarStrip.Visible = ShowPanelsCheckBox.Checked

        ' 禁用计时器，所以进度栏停止前进
        If ProgressBarPanelCheckBox.Checked And ShowPanelsCheckBox.Checked Then
            Timer1.Enabled = True
        ElseIf Not ShowPanelsCheckBox.Checked Then
            Timer1.Enabled = False
        End If
    End Sub

    Private Sub ProgressBarPanelCheckBox_CheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ProgressBarPanelCheckBox.CheckedChanged
        ' 如果不在状态栏上显示 progressbar 面板，则禁用计时器。
        Timer1.Enabled = ProgressBarPanelCheckBox.Checked
        Me.progressBarStrip.Visible = Me.ProgressBarPanelCheckBox.Checked
    End Sub

    Private Sub NumLockPanelCheckBox_CheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NumLockPanelCheckBox.CheckedChanged
        numLock.Visible = NumLockPanelCheckBox.Checked
    End Sub


    Private Sub CapsLockpanelCheckBox_CheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CapsLockpanelCheckBox.CheckedChanged
        capsLock.Visible = CapsLockpanelCheckBox.Checked
    End Sub

    Private Sub DatePanelCheckBox_CheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DatePanelCheckBox.CheckedChanged
        Me.dateLabel.Visible = DatePanelCheckBox.Checked
    End Sub

    Private Sub ShowTextPanelCheckBox_CheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ShowTextPanelCheckBox.CheckedChanged
        status.Visible = ShowTextPanelCheckBox.Checked
    End Sub

    Private Sub TextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox1.TextChanged
        ' 更新状态栏文本和包含在第一个状态栏面板中的文本。
        StatusStrip1.Text = TextBox1.Text
        status.Text = TextBox1.Text
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If Me.progressBarStrip.Value < progressBarStrip.Maximum Then
            progressBarStrip.Increment(progressBarStrip.Step)
        Else
            progressBarStrip.Value = progressBarStrip.Minimum
        End If
        ' 我们调用 DoEvents 并刷新状态栏，于是激发了 drawitem 事件。
        Me.StatusStrip1.Invalidate()
    End Sub


    Private Sub CheckLockKeys()
        ' 如果 CapsLock 键更改，则更改 CapsLock statusbarpanel 的值。
        If My.Computer.Keyboard.CapsLock Then
            capsLock.Text = "CAP"
            capsLock.BorderStyle = Border3DStyle.Raised
        Else
            capsLock.Text = ""
            capsLock.BorderStyle = Border3DStyle.Sunken
        End If

        ' 如果 NumLock 键更改，则更改 NumLock statusbarpanel 的值。
        If My.Computer.Keyboard.NumLock Then
            numLock.Text = "NUM"
            numLock.BorderStyle = Border3DStyle.Raised
        Else
            numLock.Text = ""
            numLock.BorderStyle = Border3DStyle.Sunken
        End If
    End Sub

    Private Sub Form1_KeyDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles MyBase.KeyDown, MyBase.KeyDown, MyBase.KeyDown, MyBase.KeyDown, DatePanelCheckBox.KeyDown, CapsLockpanelCheckBox.KeyDown, ShowTextPanelCheckBox.KeyDown, NumLockPanelCheckBox.KeyDown, ProgressBarPanelCheckBox.KeyDown, ShowPanelsCheckBox.KeyDown, TextBox1.KeyDown, MyBase.KeyDown, MyBase.KeyDown, MyBase.KeyDown, MyBase.KeyDown
        ' 检查按下的键是否是我们感兴趣的两个锁定键之一。
        If e.KeyCode = Keys.CapsLock Or e.KeyCode = Keys.NumLock Then
            CheckLockKeys()
        End If
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
